/*
 ============================================================================
 Name        : FP_user.c
 Author      : Yixiang
 Version     :
 Copyright   : 
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#include 	<stdio.h>
#include 	<stdint.h>
#include 	<stdlib.h>
#include 	<sys/stat.h>
#include 	<sys/mman.h>
#include 	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/types.h>
#include 	<sys/ioctl.h>
#include	<sys/time.h>
#include 	<string.h>
#include	<rtai.h>
#include    <rtai_lxrt.h>
#include	<rtai_fifos.h>
#include 	<net/if.h>
#include 	<netinet/in.h>
#include 	<netdb.h>
#include	<fcntl.h>
#include	<semaphore.h>
#include 	<unistd.h>
#include 	<arpa/inet.h>
#include 	<errno.h>


#define MSG_SIZE 40

//variables that are shared by main program and pthread

int Lightflag;		//the status of red LED

int Warningflag;	//the status for touch sensor, used for a different pthread
					//which created by a specific command

void error(const char *msg)		//for printing the error message
{
    perror(msg);
    exit(0);
}

void *light_status(void *ptr)	//pthread used for receiving the red LED status from fifo 0
								//and then it wll updates the flag value into the global variable
								//"Lightflag"
{
	int fd_fifo_1;
	int lightflag;

	fd_fifo_1 = open ("/dev/rtf/1", O_RDWR);	//to access fifo 0

	while(1)
	{
		read(fd_fifo_1,&lightflag,sizeof(lightflag));//receive the flag data from kernel module

		Lightflag = lightflag;	//update the lightflag data

	}
	close(fd_fifo_1);

	return NULL;
}

void *touch_sensor_status(void *ptr)	//This pthread is created whenever the program receives the
									//"PROTECT" command from network. The pthread will destroy itself
									//when the function is finished.
{
	int fd_fifo_0;
	int warningflag;		//store the value received from kernel module

	fd_fifo_0 = open ("/dev/rtf/0", O_RDWR);	//to access fifo 0

	while( Warningflag != 1 )		//If the sensor has not been touched, the pthread will keep reading
									//the data from fifo until it receices the trigger value which means
									//the touch is detected!
	{
		read(fd_fifo_0,&warningflag,sizeof(warningflag));		//receive the flag from kernel module

		Warningflag = warningflag;	//update the value to global variable warning_flag
	}
	close(fd_fifo_0);

	return NULL;
}

int main(int argc, char *argv[])
{
	int a;	//not using for pthread
	pthread_t thrd1;
	pthread_t thrd2;


	//UDP connection
	int length;
	int boolval = 1;			//for a socket option
	struct sockaddr_in server;
	char buf[MSG_SIZE];			//for store the receiving message
	int sock, n;				//sock used to send the broadcast message
	struct sockaddr_in from;
	socklen_t fromlen;

	char msg1[MSG_SIZE] = "CHECK";
	char msg2[MSG_SIZE] = "SWITCH";
	char msg3[MSG_SIZE] = "PROTECT";

	unsigned long *VIC2base, *VIC2SoftInt;	//variable to access the software interrupt
	int fd_map;		//variable for "mmap" function

	//create the network communication
	if (argc < 2)
	{
	   fprintf(stderr, "ERROR, no port provided\n");
	   exit(0);
	}

	sock = socket(AF_INET, SOCK_DGRAM, 0); // Creates socket. Connectionless.
	if (sock < 0)
	   error("Opening socket");
	length = sizeof(server);					// length of structure
	bzero(&server,length);						// sets all values to zero. memset() could be used
	server.sin_family = AF_INET;				// symbol constant for Internet domain
	server.sin_addr.s_addr = INADDR_ANY;		// IP address of the machine on which
												// the server is running
	server.sin_port = htons(atoi(argv[1]));		// port number

   // binds the socket to the address of the host and the port number
   if (bind(sock, (struct sockaddr *)&server, length) < 0)
	   error("binding");

   // set broadcast option
   if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0)
   {
	   printf("error setting socket options\n");
	   exit(-1);
   }

   fromlen = sizeof(struct sockaddr_in);	// size of structure

   //after the network connection is created, inialize the pthread which keeps updating the
   //red LED status
   pthread_create(&thrd1,NULL,light_status,&a);

   //map the software interrupt register address
   fd_map = open("/dev/mem", O_RDWR | O_SYNC );
   if(fd_map < 0)
	   printf("mmap open error!\n");

   VIC2base = (unsigned long *)mmap(NULL,
		   getpagesize(),
		   PROT_READ|PROT_WRITE,
		   MAP_SHARED,
		   fd_map,
		   0x800C0000);
   VIC2SoftInt = (unsigned long*)((char *)VIC2base + 0x18);

   //server operation
   while (1)
   {
	   // bzero: to "clean up" the buffer. The messages aren't always the same length.
	   bzero(buf,MSG_SIZE);

	   // receive the message from client
	   n = recvfrom(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&from, &fromlen);
	   if (n < 0)
		   error("recvrmmfrom");
	   printf("\nReceived a datagram: ");	//print the received message
	   printf("%s\n", buf);

	   if( strncmp(buf,msg1,5) ==0  )	//if message received is "CHECK"
	   {
		   if(Lightflag == 1)	//compare the value from Lightflag variable which should be updated by
			   	   	   	   	   	//"lightstatus" pthread. "1" means the light is on. "0" means the light is off.

			   n = sendto(sock,"The light is On!\n",16,0,(struct sockaddr *)&from,fromlen);	//send the light staus message
		   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	//back to client
		   else
			   n = sendto(sock,"The light is Off!\n",17,0,(struct sockaddr *)&from,fromlen);
	   }
	   else if ( strncmp(buf,msg2,6) ==0 )	//if message received is "SWITCH"
   	   {
		   *VIC2SoftInt |= 0x80000000;	//triggered the software interrupt which is used for switching the red LED
		   n = sendto(sock,"Light is Switched!\n",18,0,(struct sockaddr *)&from,fromlen);	//update to the client that the
		   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	//operation is complete
	   }
	   else if( strncmp(buf,msg3,7) ==0)	//if message received is "PROTECT"
	   {
		   Warningflag = 0;		//initial the warningflag value
		   pthread_create(&thrd2,NULL,touch_sensor_status,&a);	//create the pthread which updates the warningflag value

		   while( Warningflag != 1)		//wait for the warning flag triggered in terms of the trigger of touch sensor
		   {

		   }
		   n = sendto(sock,"WARNING!!!\n",10,0,(struct sockaddr *)&from,fromlen);	//Whenever the trigger happens, send
		   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	//the warning message back to the
		   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	//client.
	   }
	   else
	   {
		   n = sendto(sock,"Error Input!\n",12,0,(struct sockaddr *)&from,fromlen);
	   }
	   if (n  < 0)
		   error("sendto");
   }

   return 0;

}
